import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

function getDb() {
    const dbPath = path.join(process.cwd(), 'domains.db');
    return new Database(dbPath);
}

export async function GET(_: NextRequest, { params }: { params: Promise<{ id: string }> }) {
    const { id } = await params;
    const db = getDb();
    try {
        const tasks = db.prepare(`
            SELECT * FROM tasks_full_view 
            WHERE domain_id = ? 
            ORDER BY 
                CASE priority 
                    WHEN 'urgent' THEN 1 
                    WHEN 'high' THEN 2 
                    WHEN 'medium' THEN 3 
                    ELSE 4 
                END,
                COALESCE(due_date, '9999-12-31') ASC
        `).all(id);
        return NextResponse.json(tasks);
    } catch (e: any) {
        console.error('Get domain tasks error:', e);
        return NextResponse.json({ error: 'שגיאה בטעינת משימות: ' + e.message }, { status: 500 });
    } finally {
        db.close();
    }
}
